#TRUSTED 0c570fb11f96a1cd1f4cf9d7e32632cd450abcc395c34a53529c06e8bc5604d8499e83e03f482eb190afefc23e7a5fefa5d1d62c74134aff8a394db17b7a0eb3355a6f13316035b7379c9ea087e849bb4fd8edbe9c22c0d621cca2754c323450fe0adcb454295f42936e906ad5ff1566aeb8b67f9e20f7094b121caee7ebbac16a8e54f3dac9875accb4e641ac408f8dddd6b4237059914767f861a76351c60b2b31504f98584d34a0d810d660ee9216b9f2392b5833dda7e9b1b42e0b4b61eb44c9a73da7c1bf1c5069171f9215f242173b9ec22891f3fd9bb8f1b545c9a7f36d52b28789f75264c83cb0d69474858cd569895c0ff0b1e9b87c92df87ee9aa3a8004c7bb48a6a21ab5d0234ede00321324a4b5af8064e87f18390b653b22f7c8033cbb64563a12bdd6cdfe066c679366ef1c42c0dea274cfbf669e3c6933bd9d90400e91726e8785058e16621d1f044faca82fc85cd58faea1b6a18ffa0ef1e0af5215c0e8ab3542a2081d6e2dccc0abd80d8b7dc6d974517dd715c516971fc7d9fd00d431445c2237c349092b4bf84be2f3e7f24d8deb29714385271e903fe0b88b9df4e9f0d834f47181d6ae457c0525ddf20410c34a0409c88979951f029ca47bf2384479b3aad35ff9442885e12c01065f828918c07d98966ca89809a63ffe8edcb8c560623e50582e2dfddb6119bffedc37c5841ff76394f701714e831
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24812);
 script_version ("1.0");
 script_cve_id("CVE-2007-0051");
 name["english"] = "iPhoto < 6.0.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote system is missing a security update

Description :

The remote host is running a version of iPhoto 6 which is older than 
version 6.0.6

The remote version of iPhoto contains a security vulnerability which
may allow an attacker to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to lure a user
on the remote host into subscribing to a malicious photocast
album


Solution : 

http://docs.info.apple.com/article.html?artnum=305215

See also :

http://docs.info.apple.com/article.html?artnum=305215

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for iPhoto 6.0.6";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


cmd = GetBundleVersionCmd(file:"iPhoto.app", path:"/Applications");
uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  if ( islocalhost() )
   buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
  else 
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:cmd);
   ssh_close_connection();
  }

 if ( buf )
 {
  vers = split(buf, sep:'.', keep:FALSE);
  if ( int(vers[0]) == 6 && int(vers[1]) == 0 && int(vers[2]) < 6  ) security_warning(0);
 }  
}
