#TRUSTED 29eff851c2d0ee94420b554e1ce154e78fa68a540df4103366e9975a1c65a38194bb52cd6819c1f7bdb26d3539fa28f3505d29cf954ea69f9f9af4a4905dd4da3b41bae2730b9d223be992135614959ba4f92e69581071db05c8ae1562d64a0c3d13f90cb027c262950cd31a4f52be43fb8779efb33de5de8ff744a5d2c818a6c6519b5bfd7a77f2822755587dee3d581411a67a3e2bb416a44fb7b2b9ce6f78c5dbb0728c4a380d6778212fb8a1e8be9a76bf0a17eddd86c36ede6b8de3324fd9d8c94b4199fd461bfaf246174a5a393a03adebc6c87b643b6da7f109888895fb56fcd526f8ef1613e70feeb3f3fc53ec598b093438e80c6b19b94d6e86d1a6731de5c8db9c6909f99403c3e5e28cb908343206d45e0aacf371c044c63afb95e9b999da5648ff57c9739cfd14de66b5c742950381e4ad6e35cee63bc6485811f56ee165e2a9c30fe278047dd463576d0e51c0f57c058dacd139f11539af2aa0e82059394ae2b73fd976428f8c387f52a22b08d5072e86e062b1cc57840ba17f6dc984dd30db592f9c943a8143dd3fe9d0a2ff5441d3815b8d9591ae6d1983ee2c1f4845aea4964ef925835dbe595f90620e9f999f4cc80f0fab21371a56f411046786a0dc8f9f391c5ef0e8eb1b9ef3d133a97deff9ac0cd9d610791c85ea8c052d632bfa916af6a5475474d69344f57b0d175bef7e52d2854f8b038e503a06
#
#  (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Mac OS X host has a copy of iTunes installed.

Description :

The remote host is running iTunes, a popular jukebox program. 

Risk factor :

None";

if (description)
{
  script_id(25997);
  script_version("1.0");

  script_name(english:"iTunes Version Detection (Mac OS X)");
  script_summary(english:"Check the version of iTunes"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"MacOS X Local Security Checks");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
  script_dependencies("ssh_get_info.nasl");
  script_require_keys("Host/MacOSX/packages");
  exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");


cmd = GetBundleVersionCmd(file:"iTunes.app", path:"/Applications");
uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  if ( islocalhost() )
   buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
  else
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:cmd);
   ssh_close_connection();
  }

 if ( buf )
 {
  vers = split(chomp(buf), sep:'.', keep:FALSE);
  set_kb_item(name:"MacOSX/iTunes/Version", value:string(int(vers[0]), ".", int(vers[1]), ".", int(vers[2])));
  security_note(port:0, extra:'iTunes ' + string(int(vers[0]), ".", int(vers[1]), ".", int(vers[2])) + ' is installed on the remote host');
 }
}

