#TRUSTED 4ee91710e8164d097400afc4dd3f98d11358aad9a83ae568416540ac81b926f1c2d840e70960e398e48020f1bb9aceec87d8fba5fc2f286c1f1e185d931eddadf122002082bec3c8e08c2d9c2d26fb3ce5451ae003818d034936aabe58882e5910955a8c075008d6dfeed86d0783d80c7c9bef923791fe15d217bb6f36a21d1f6a812602ed572925e04b8914b298828b0f315f5a31de100ca629f7168801a81e6d7474874a1c01e2bc0c9bbf2887656a5113de90ca1e1c161b6ef50a6631881edba8deeac2382a814f1dfeb61a1306924debcd13e8cbfc3cfa0288a95534fa492398286c40b980b4cbb108154b84aece3cfed0d9e42253bef25ef32d7d9a9b0353a29663d0c1969027087742085a9b34709a2fbd2853202951d905627b80c5e36d9777c011efb7efff8a849fdab6c8308d96d129e54cb9001d5eec5eda24a5456d414b06fa12fe2c0d612e363a6b9a0d182f665a66f94790302e7325dacc8234928b4967d72de4079b9f2510e47252f5271d0f0a90c4dcaf9793d48f086b62ddd6e000548e267eebf6bfa6599044451766e1c4a8edf48dea8143e065fb2641ea1e1c135b20734c5ebc7342587a8e1642f8cf21ddf2541994b781113496de7c240c79f0a23b3705743f4d8c73814e2418e49065b0f1130d5d4491ab9a1981c0160291c44d33291d20e721fb4aa048c5eb896890d11f32c65c0818093847df4e14
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(21724);
 script_version ("1.1");
 script_bugtraq_id ( 18382 );
 script_cve_id("CVE-2006-0022");
 script_xref(name:"OSVDB", value:"26435");
 name["english"] = "Vulnerability in Microsoft PowerPoint Could Allow Remote Code Execution (916768) (Mac OS X)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Microsoft
PowerPoint.

Description :

The remote host is running a version of Microsoft PowerPoint
which is subject to a flaw which may allow arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to 
a user of the remote computer and have it open it. Then a bug in
the font parsing handler would result in code execution.

Solution : 

Microsoft has released a set of patches for PowerPoint X and 2004 for 
Mac OS X :

http://www.microsoft.com/technet/security/bulletin/ms06-028.mspx

Risk factor : 

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for PowerPoint 2004 and X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  off2004 = GetCarbonVersionCmd(file:"Microsoft PowerPoint", path:"/Applications/Microsoft Office 2004");
  offX    = GetCarbonVersionCmd(file:"Microsoft PowerPoint", path:"/Applications/Microsoft Office X");

  if ( ! islocalhost() )
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:off2004);
   if ( buf !~ "^11" )
    buf = ssh_cmd(socket:soc, cmd:offX);
   ssh_close_connection();
  }
  else
  {
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", off2004));
  if ( buf !~ "^11" )
    buf = pread(cmd:"bash", argv:make_list("bash", "-c", offX));
  }


 if ( buf =~ "^(10\.|11\.)" )
	{
	  vers = split(buf, sep:'.', keep:FALSE);
	  # < 10.1.7
	  if ( int(vers[0]) == 10 && ( int(vers[1]) < 1  || ( int(vers[1]) == 1 && int(vers[2]) < 7 ) ) ) security_hole(0);
	  else
          # < 11.2.4
	  if ( int(vers[0]) == 11 && ( int(vers[1]) < 2  || ( int(vers[1]) == 2 && int(vers[2]) < 4 ) ) ) security_hole(0);
	} 
}
