#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23754);
  script_version("$Revision: 1.3 $");

  script_bugtraq_id(21252);

  script_name(english:"MailEnable IMAP Service Unspecified Buffer Overflow Vulnerability (ME-10018)");
  script_summary(english:"Checks version of MailEnable's MEIMAPS.exe");

  desc = "
Synopsis :

The remote IMAP server is prone to a buffer overflow attack. 

Description :

The IMAP server bundled with the version of MailEnable installed on
the remote host is affected by an unspecified denial of service and
potential buffer overflow vulnerability.  A remote attacker may be
able to exploit this issue to crash the affected service or to execute
arbitrary code with LOCAL SYSTEM privileges. 

See also :

http://www.mailenable.com/hotfix/

Solution :

Apply Hotfix ME-10018. 

Risk factor :

Critical / CVSS Base Score : 10 
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("mailenable_detect.nasl");
  script_require_keys("SMB/MailEnable/Installed");
  script_require_ports(139, 445);

  exit(0);
}


include("misc_func.inc");


if (!get_kb_item("SMB/MailEnable/Installed")) exit(0);
if (get_kb_item("SMB/MailEnable/Standard")) prod = "Standard";
if (get_kb_item("SMB/MailEnable/Professional")) prod = "Professional";
else if (get_kb_item("SMB/MailEnable/Enterprise")) prod = "Enterprise";


# Check version of MEIMAPS.exe.
if (prod == "Professional" || prod == "Enterprise")
{
  kb_base = "SMB/MailEnable/" + prod;
  ver = read_version_in_kb(kb_base+"/MEIMAPS/Version");
  if (isnull(ver)) exit(0);

  # nb: file version for MEIMAPS.exe from ME-10018 is 1.0.0.25.
  if (
    ver[0] == 0 ||
    (ver[0] == 1 && ver[1] == 0 && ver[2] == 0 && ver[3] < 25)
  )
  {
    # Let's make sure the product's version number agrees with what's reportedly affected.
    # nb: MailEnable version numbers are screwy!
    ver2 = get_kb_item(kb_base+"/Version");
    if (isnull(ver2)) exit(0);

    if (
      # 1.6-1.82 Professional Edition
      # 2.0-2.32 Professional Edition
      (prod == "Professional" && ver2 =~ "^(1\.([67]($|[0-9.])|8$|8[0-2])|2\.([0-2]($|[0-9.])|3($|[012])))") ||
      # 1.1-1.30 Enterprise Edition
      # 2.0-2.32 Enterprise Edition
      (prod == "Enterprise" && ver2 =~ "^(1\.([12]($|[0-9].)|3$)|2\.([0-2]($|[0-9.])|3($|[012])))")
    ) security_hole(get_kb_item("SMB/transport"));
  }
}
