#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23756);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2006-6290", "CVE-2006-6291");
  script_bugtraq_id(21362);
  script_xref(name:"OSVDB", value:"30661");
  script_xref(name:"OSVDB", value:"31698");
  script_xref(name:"OSVDB", value:"31699");

  script_name(english:"MailEnable IMAP Service Multiple Buffer Overflow Vulnerabilities (ME-10021)");
  script_summary(english:"Checks version of MailEnable's MEIMAPS.exe");

  desc = "
Synopsis :

The remote IMAP server is affected by multiple buffer overflow
vulnerabilities. 

Description :

The IMAP server bundled with the version of MailEnable installed on
the remote host reportedly fails to handle malicious arguments to the
'EXAMINE', 'SELECT', and 'DELETE' commands.  An authenticated remote
attacker may be able to exploit these issues to crash the affected
service or to execute arbitrary code with LOCAL SYSTEM privileges. 

See also :

http://secunia.com/secunia_research/2006-71/advisory/
http://archives.neohapsis.com/archives/fulldisclosure/2006-11/0535.html
http://www.mailenable.com/hotfix/

Solution :

Apply Hotfix ME-10021. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:L/Au:S/C:N/I:N/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("mailenable_detect.nasl");
  script_require_keys("SMB/MailEnable/Installed");
  script_require_ports(139, 445);

  exit(0);
}


include("misc_func.inc");


if (!get_kb_item("SMB/MailEnable/Installed")) exit(0);
if (get_kb_item("SMB/MailEnable/Standard")) prod = "Standard";
if (get_kb_item("SMB/MailEnable/Professional")) prod = "Professional";
else if (get_kb_item("SMB/MailEnable/Enterprise")) prod = "Enterprise";


# Check version of MEIMAPS.exe.
if (prod == "Professional" || prod == "Enterprise")
{
  kb_base = "SMB/MailEnable/" + prod;
  ver = read_version_in_kb(kb_base+"/MEIMAPS/Version");
  if (isnull(ver)) exit(0);

  # nb: file version for MEIMAPS.exe from ME-10021 is 1.0.0.26.
  if (
    ver[0] == 0 ||
    (ver[0] == 1 && ver[1] == 0 && ver[2] == 0 && ver[3] < 26)
  )
  {
    # Let's make sure the product's version number agrees with what's reportedly affected.
    # nb: MailEnable version numbers are screwy!
    ver2 = get_kb_item(kb_base+"/Version");
    if (isnull(ver2)) exit(0);

    if (
      # 1.6-1.83 Professional Edition
      # 2.0-2.33 Professional Edition
      (prod == "Professional" && ver2 =~ "^(1\.([67]($|[0-9.])|8$|8[0-3])|2\.([0-2]($|[0-9.])|3($|[0-3])))") ||
      # 1.1-1.40 Enterprise Edition
      # 2.0-2.33 Enterprise Edition
      (prod == "Enterprise" && ver2 =~ "^(1\.([1-3]($|[0-9].)|4$)|2\.([0-2]($|[0-9.])|3($|[0-3])))")
    ) security_warning(get_kb_item("SMB/transport"));
  }
}
