#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30110);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(27472);

  script_name(english:"Mambo MOStlyCE Mambot File Rename Vulnerability");
  script_summary(english:"Tries to rename a non-existent file");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
several issues. 

Description :

The remote host is running MOStlyContent Editor (MOStlyCE), the
default WYSIWYG editor for Mambo. 

The version of MOStlyCE installed on the remote host contains a design
flaw that may allow an attacker to rename files subject to the
privileges of the web server user id.  An unauthenticated attacker may
be able to leverage this issue to disable the application and/or
uncover the contents of sensitive files by, say, renaming Mambo's
configuration file and then issuing a request for the file using its
new name. 

There is also a reported cross-site scripting vulnerability involving
the 'Command' parameter of MOStlyCE's 'connector.php' script, although
Nessus has not verified this. 

See also :

http://www.milw0rm.com/exploits/4845

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:N/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("mambo_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/mambo_mos"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the issue to rename a non-existent file.
  #
  # nb: this check only determines if the code is vulnerable, not whether
  #     the upload directory actually exists, a necessary condition for
  #     exploiting the issue.
  name = "nessus.gif";
  tmp_name = string(SCRIPT_NAME, "-", unixtime());

  req = http_get(
    item:string(
      dir, "/mambots/editors/mostlyce/jscripts/tiny_mce/filemanager/connectors/php/connector.php?",
      "Command=FileUpload&",
      "file=a&",
      "file[NewFile][name]=", name, "&",
      "file[NewFile][tmp_name]=", tmp_name, "&",
      "file[NewFile][size]=1&",
      "CurrentFolder="
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see an error related to the rename operation.
  if (
    string("Error Message: rename(", tmp_name, ",") >< res &&
    string(name, "): No such file or directory <br />") >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
