#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:045
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24471);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:045: ghostscript";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:045 (ghostscript).

New ghostscript packages are now available that provide ghostscript
8.15.1 final and provide a number of bug fixes, including:
A fix for vertical japanese text.
A memory overflow in the 'lips4' driver was fixed.
A double-free in gsdevice.c was fixed.
A SEGV in the 'inferno' driver was fixed; this was because the struct
'inferno_device' was not created but it was accessed to its elements.
The shared X11 driver was not built with the correct linker command
(CCLD instead of CC_SHARED).
The 'opvp' driver incorrectly assumed that CODESET was supported on all
platforms that supported iconv.
Support in the 'cups' driver for CUPS_CSPACE_RGBW colorspace was added.
Other fixes are also included in these new packages.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:045
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ghostscript package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ghostscript-8.15-22.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-module-X-8.15-22.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libijs1-0.35-22.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libijs1-devel-0.35-22.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-8.15-22.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-module-X-8.15-22.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libijs1-0.35-22.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libijs1-devel-0.35-22.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
