#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:048
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24474);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:048: mdkonline";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:048 (mdkonline).

Updated mdkonline packages are now available that change the name of
the main binary from MandrakeUpdate to MandrivaUpdate due to Mandriva's
name change.
As well, this update provides fixes the account creation and
authentication based on obsolete architectures (versions prior to
2006.0). The user email address is now used as a unique login
throughout all Mandriva web services.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:048
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mdkonline package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mdkonline-1.3-6.1.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mdkonline-1.3-6.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mdkonline-1.3-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
