#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:050
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24476);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:050: scim-qtimm";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:050 (scim-qtimm).

Due to a bug in the RPM requires for the scim-qtimm package, it was
only installable on i586 platforms, and not on x86_64 due to
differences in the naming for libqt3 (vs. lib64qt3).
This update corrects the requires allowing the package to be installed
on Mandriva Linux 2006/x86_64.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:050
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the scim-qtimm package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"scim-qtimm-0.9.4-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
