#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:055
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24481);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:055: acpid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:055 (acpid).

A number of bugs have been fixed in this new acpid package:
Correct an error in the initscript, to look for lm_battery.sh rather
than battery.sh.
Correct an issue where logrotate of acpid's log files would cause the
X server to consume 100% cpu.
Note: In order to restart the acpid service you may have to stop X
(telinit 3 if you use a graphical login, or exit X if you use startx).

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:055
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the acpid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"acpid-1.0.4-6.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
