#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:002
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24490);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:002: mdkonline";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:002 (mdkonline).

A bug in the mdkupdate cron job (when automatic update mode is enabled)
prevents $ENV{USER} from being defined, which kills mdkupdate before
performing the updates.
The mdkapplet GUI is now refreshed and doesn't stall anymore when waiting
for configuration or installation operations to finish prior to
re-drawing itself.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:002
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mdkonline package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mdkonline-1.3-6.2.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mdkonline-1.3-6.2.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mdkonline-1.3-6.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
