#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:005
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24492);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:005: kat";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:005 (kat).

A number of fixes are available with this new kat update including a
fix in the support of utf8 files, a number of crash situation were
corrected, a double deletion that caused a crash when kat was closed
was corrected, and finally the mail indexer is disabled due to
problems it caused.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:005
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kat-0.6.4-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libkat0-0.6.4-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libkat0-devel-0.6.4-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
