#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:010
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24496);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:010: klamav";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:010 (klamav).

Klamav 0.32 is now available for Mandriva Linux 2006 that fixes a
number of problems with the previous version:
- fix the proxy configuration; password-less proxies can now be used
- fix media:/ vs. devices:/ difference on different KDE versions
- translation of HTML advisory files; English and Brazilian Portuguese
are now available
- fix translation for all programs; a new klamav.pot file generated
against the full string translation code
- full English and Brazilian Portuguese are now available

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:010
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the klamav package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"klamav-0.32-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
