#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:065
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24536);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:065: hal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:065 (hal).

A bug in partition detection for some SD/MMC card readers (those using
the sdhci driver) was preventing correct detection by HAL, breaking
automatic mounting/unmounting on card insertion/removal. Another bug
was preventing correct mounting of LUKS-encrypted removable media. This
update fixes these bugs and also provides compatibility with D-Bus 1.0.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:065
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the hal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"hal-0.5.7.1-9.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"hal-gnome-0.5.7.1-9.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libhal1-0.5.7.1-9.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libhal1-devel-0.5.7.1-9.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
