#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:005
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24542);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:005: nmap";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:005 (nmap).

The version of nmap shipped with Mandriva Linux 2007 was built against
the system copies of the libpcap and libdnet libraries. However, nmap
actually requires changes to be made to these libraries which have not
yet been made to the upstream versions, and consequently should be
compiled against its own built-in copies of these libraries. This
problem causes nmap not to work as the root user: it would simply
freeze up. The updated package fixes this problem. It also fixes the
menu entry for the package.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:005
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nmap package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"nmap-4.11-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"nmap-frontend-4.11-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
