#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:007
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24544);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:007: lirc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:007 (lirc).

Dkms-lirc allows one to install LIRC drivers on non-Mandriva kernels.
It contains a driver named lirc_parallel.ko which does not work on
SMP-enabled kernels, preventing the driver installation on such
kernels. The lirc_parallel.ko driver has been removed from the updated
package and moved to a separate package named dkms-lirc-parallel.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:007
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lirc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"dkms-lirc-0.8.1-0.20060722.4.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"dkms-lirc-parallel-0.8.1-0.20060722.4.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"liblirc0-0.8.1-0.20060722.4.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"liblirc0-devel-0.8.1-0.20060722.4.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"lirc-0.8.1-0.20060722.4.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
