#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:021
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24890);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:021: methane";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:021 (methane).

The methane package was not installable due to a conflicts with itself
that should have been a conflicts with methane_new.
The updated packages correct the conflicts so methane is now
installable.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:021
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the methane package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"methane-1.4.6-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
