#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:080
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25696);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:080: hdf5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:080 (hdf5).

On mandriva 2007.0, hdf5 couldn't be installed due to the lack of
libh5test.so.0 in its library packages.
This release fixes tests and provides the libh5test.so.0 file.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:080
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the hdf5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"hdf5-1.6.5-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libhdf5_0-1.6.5-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libhdf5_0-devel-1.6.5-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
