#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:127
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23878);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3404");
 
 name["english"] = "MDKSA-2006:127: gimp";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:127 (gimp).

A buffer overflow in the xcf_load_vector function in app/xcf/xcf-load.c
for gimp 2.2.x allows user-complicit attackers to cause a denial of
service (crash) and possibly execute arbitrary code via an XCF file
with a large num_axes value in the VECTORS property.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:127
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gimp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gimp-2.2.8-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-python-2.2.8-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgimp2.0_0-2.2.8-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgimp2.0-devel-2.2.8-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"gimp-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-3404", value:TRUE);
}
