#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:152
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23898);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4330", "CVE-2006-4331", "CVE-2006-4332");
 
 name["english"] = "MDKSA-2006:152: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:152 (wireshark).

Vulnerabilities in the SCSI, DHCP, and SSCOP dissectors were discovered
in versions of wireshark less than 0.99.3, as well as an off-by-one
error in the IPsec ESP preference parser if compiled with ESP
decryption support.
This updated provides wireshark 0.99.3a which is not vulnerable to
these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:152
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwireshark0-0.99.3a-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tshark-0.99.3a-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.3a-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-tools-0.99.3a-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"wireshark-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4330", value:TRUE);
 set_kb_item(name:"CVE-2006-4331", value:TRUE);
 set_kb_item(name:"CVE-2006-4332", value:TRUE);
}
