#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:155
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23899);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3743", "CVE-2006-3744", "CVE-2006-4144");
 
 name["english"] = "MDKSA-2006:155: ImageMagick";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:155 (ImageMagick).

Multiple buffer overflows in ImageMagick before 6.2.9 allow user-assisted
attackers to execute arbitrary code via crafted XCF images. (CVE-2006-3743)
Multiple integer overflows in ImageMagick before 6.2.9 allows user-assisted
attackers to execute arbitrary code via crafted Sun bitmap images that trigger
heap-based buffer overflows. (CVE-2006-3744)
Integer overflow in the ReadSGIImage function in sgi.c in ImageMagick before
6.2.9 allows user-assisted attackers to cause a denial of service (crash)
and possibly execute arbitrary code via large (1) bytes_per_pixel, (2)
columns, and (3) rows values, which trigger a heap-based buffer overflow.
(CVE-2006-4144)
The updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:155
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ImageMagick package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ImageMagick-6.2.4.3-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ImageMagick-doc-6.2.4.3-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libMagick8.4.2-6.2.4.3-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libMagick8.4.2-devel-6.2.4.3-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Image-Magick-6.2.4.3-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"ImageMagick-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-3743", value:TRUE);
 set_kb_item(name:"CVE-2006-3744", value:TRUE);
 set_kb_item(name:"CVE-2006-4144", value:TRUE);
}
