#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:157
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23901);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4197");
 
 name["english"] = "MDKSA-2006:157: musicbrainz";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:157 (musicbrainz).

Multiple buffer overflows in libmusicbrainz (aka mb_client or
MusicBrainz Client Library) 2.1.2 and earlier, and SVN 8406 and
earlier, allow remote attackers to cause a denial of service (crash)
or execute arbitrary code via (1) a long Location header by the HTTP
server, which triggers an overflow in the MBHttp::Download function in
lib/http.cpp; and (2) a long URL in RDF data, as demonstrated by a URL
in an rdf:resource field in an RDF XML document, which triggers
overflows in many functions in lib/rdfparse.c.
The updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:157
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the musicbrainz package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libmusicbrainz4-2.1.1-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmusicbrainz4-devel-2.1.1-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"musicbrainz-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4197", value:TRUE);
}
