#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:163
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23907);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4095", "CVE-2006-4096");
 
 name["english"] = "MDKSA-2006:163: bind";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:163 (bind).

A vulnerability in BIND was discovered where it did not sufficiently
verify particular requests and responses from other name servers and
users. This could be exploited by sending a specially crafted packet
to crash the name server.
Updated packages have been patched to address these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:163
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bind-9.3.1-4.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-devel-9.3.1-4.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.1-4.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"bind-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4095", value:TRUE);
 set_kb_item(name:"CVE-2006-4096", value:TRUE);
}
