#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:170-1
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24556);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4542");
 
 name["english"] = "MDKSA-2006:170-1: webmin";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:170-1 (webmin).

Webmin before 1.296 and Usermin before 1.226 does not properly handle a
URL with a null ('%00') character, which allows remote attackers to
conduct cross-site scripting (XSS), read CGI program source code, list
directories, and possibly execute programs.
Updated packages have been patched to correct this issue.
Update:
Packages are now available for Mandriva Linux 2007.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:170-1
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the webmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"webmin-1.290-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"webmin-1.290-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"webmin-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-4542", value:TRUE);
}
