#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:183
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24568);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5111");
 
 name["english"] = "MDKSA-2006:183: libksba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:183 (libksba).

The libksba library, as used by gpgsm in the gnupg2 package, allows
attackers to cause a denial of service (application crash) via a
malformed X.509 certificate in a signature.
libksba-0.9.15 in Mandriva 2007.0 is not affected by this issue.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:183
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libksba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libksba8-0.9.11-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libksba8-devel-0.9.11-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libksba-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-5111", value:TRUE);
}
