#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:202
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24587);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4513");
 
 name["english"] = "MDKSA-2006:202: wv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:202 (wv).

Multiple integer overflows in the WV library in wvWare (formerly
mswordview) before 1.2.3, as used by AbiWord?, KWord, and possibly
other products, allow user-assisted remote attackers to execute
arbitrary code via a crafted Microsoft Word (DOC) file that produces
(1) large LFO clfolvl values in the wvGetLFO_records function or (2) a
large LFO nolfo value in the wvGetFLO_PLF function.
Updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:202
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwv-1.0_3-1.0.3-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwv-1.0_3-devel-1.0.3-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wv-1.0.3-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwv-1.2_0-1.2.0-6.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwv-1.2_0-devel-1.2.0-6.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wv-1.2.0-6.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"wv-", release:"MDK2006.0")
 || rpm_exists(rpm:"wv-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-4513", value:TRUE);
}
