#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:207
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24592);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4339");
 
 name["english"] = "MDKSA-2006:207: bind";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:207 (bind).

The BIND DNS server is vulnerable to the recently-discovered OpenSSL
RSA signature verification problem (CVE-2006-4339). BIND uses RSA
cryptography as part of its DNSSEC implementation. As a result, to
resolve the security issue, these packages need to be upgraded and for
both KEY and DNSKEY record types, new RSASHA1 and RSAMD5 keys need to
be generated using the '-e' option of dnssec-keygen, if the current
keys were generated using the default exponent of 3.
You are able to determine if your keys are vulnerable by looking at the
algorithm (1 or 5) and the first three characters of the Base64 encoded
RSA key. RSAMD5 (1) and RSASHA1 (5) keys that start with 'AQM', 'AQN',
'AQO', or 'AQP' are vulnerable.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:207
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bind-9.3.1-4.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-devel-9.3.1-4.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.1-4.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-9.3.2-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-devel-9.3.2-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"bind-", release:"MDK2006.0")
 || rpm_exists(rpm:"bind-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-4339", value:TRUE);
}
