#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:216
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24601);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5925");
 
 name["english"] = "MDKSA-2006:216: links";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:216 (links).

The links web browser with smbclient installed allows remote attackers
to execute arbitrary code via shell metacharacters in an smb:// URI, as
demonstrated by using PUT and GET statements.
Corporate 3.0 is not affected by this issue, as that version of links
does not have smb:// URI support.
Updated packages have disabled access to smb:// URIs.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:216
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the links package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"links-2.1-0.pre18.5.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"links-common-2.1-0.pre18.5.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"links-graphic-2.1-0.pre18.5.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"links-2.1-0.pre18.13.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"links-common-2.1-0.pre18.13.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"links-graphic-2.1-0.pre18.13.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"links-", release:"MDK2006.0")
 || rpm_exists(rpm:"links-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5925", value:TRUE);
}
