#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:219
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24603);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2002-1216", "CVE-2006-6097");
 
 name["english"] = "MDKSA-2006:219: tar";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:219 (tar).

GNU tar 1.16 and 1.15.1, and possibly other versions, allows
user-assisted attackers to overwrite arbitrary files via a tar file
that contains a GNUTYPE_NAMES record with a symbolic link, which is not
properly handled by the extract_archive function in extract.c and
extract_mangle function in mangle.c, a variant of CVE-2002-1216.
The updated packages have been patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:219
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tar package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tar-1.15.1-5.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.15.91-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"tar-", release:"MDK2006.0")
 || rpm_exists(rpm:"tar-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2002-1216", value:TRUE);
 set_kb_item(name:"CVE-2006-6097", value:TRUE);
}
