#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:220
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24604);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4514");
 
 name["english"] = "MDKSA-2006:220: libgsf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:220 (libgsf).

'infamous41md' discovered a heap buffer overflow vulnerability in
libgsf, a GNOME library for reading and writing structured file
formats, which could lead to the execution of arbitrary code.
The updated packages have been patched to correct this problem.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:220
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgsf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libgsf-1_114-1.14.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgsf-1_114-devel-1.14.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgsf-1.14.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libgsf-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-4514", value:TRUE);
}
