#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:229
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24612);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5864");
 
 name["english"] = "MDKSA-2006:229: evince";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:229 (evince).

Stack-based buffer overflow in ps.c for evince allows user-assisted
attackers to execute arbitrary code via a PostScript (PS) file with
certain headers that contain long comments, as demonstrated using the
DocumentMedia header.
Packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:229
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evince package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"evince-0.6.0-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"evince-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5864", value:TRUE);
}
