#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:017
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24632);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6719");
 
 name["english"] = "MDKSA-2007:017: wget";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:017 (wget).

The ftp_syst function in ftp-basic.c in Free Software Foundation (FSF)
GNU wget 1.10.2 allows remote attackers to cause a denial of service
(application crash) via a malicious FTP server with a large number of
blank 220 responses to the SYST command.
The updated packages have been patched to correct this problem.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:017
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wget package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"wget-1.10-1.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wget-1.10.2-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"wget-", release:"MDK2006.0")
 || rpm_exists(rpm:"wget-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-6719", value:TRUE);
}
