#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:021
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24636);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0104");
 
 name["english"] = "MDKSA-2007:021: xpdf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:021 (xpdf).

The Adobe PDF specification 1.3, as implemented by xpdf 3.0.1 patch 2,
kpdf in KDE before 3.5.5, and other products, allows remote attackers
to have an unknown impact, possibly including denial of service
(infinite loop), arbitrary code execution, or memory corruption, via a
PDF file with a (1) crafted catalog dictionary or (2) a crafted Pages
attribute that references an invalid page tree node.
The updated packages have been patched to correct this problem.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:021
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xpdf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xpdf-3.01pl2-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-tools-3.01pl2-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"xpdf-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0104", value:TRUE);
}
