#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:044
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24687);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1006");
 
 name["english"] = "MDKSA-2007:044: ekiga";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:044 (ekiga).

A format string flaw was discovered in how ekiga processes certain
messages, which could permit a remote attacker that can connect to
ekiga to potentially execute arbitrary code with the privileges of
the user running ekiga.
Updated package have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:044
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ekiga package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ekiga-2.0.3-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"ekiga-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1006", value:TRUE);
}
