#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:056
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24806);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1218");
 
 name["english"] = "MDKSA-2007:056: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:056 (tcpdump).

Off-by-one buffer overflow in the parse_elements function in the 802.11
printer code (print-802_11.c) for tcpdump 3.9.5 and earlier allows
remote attackers to cause a denial of service (crash) via a crafted
802.11 frame. NOTE: this was originally referred to as heap-based, but
it might be stack-based.
Updated packages have been patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:056
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tcpdump-3.9.3-1.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcpdump-3.9.4-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"tcpdump-", release:"MDK2006.0")
 || rpm_exists(rpm:"tcpdump-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1218", value:TRUE);
}
