#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:063
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24842);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0002");
 
 name["english"] = "MDKSA-2007:063: libwpd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:063 (libwpd).

iDefense reported several overflow bugs in libwpd. An attacker
could create a carefully crafted Word Perfect file that could cause
an application linked with libwpd, such as OpenOffice, to crash or
possibly execute arbitrary code if the file was opened by a victim.
Updated packages have been patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:063
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libwpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwpd-0.8_8-0.8.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwpd-0.8_8-devel-0.8.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwpd-tools-0.8.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libwpd-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0002", value:TRUE);
}
