#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:083
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25034);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1349");
 
 name["english"] = "MDKSA-2007:083: apache-mod_perl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:083 (apache-mod_perl).

PerlRun.pm in Apache mod_perl 1.30 and earlier, and RegistryCooker.pm
in mod_perl 2.x, does not properly escape PATH_INFO before use in a
regular expression, which allows remote attackers to cause a denial
of service (resource consumption) via a crafted URI.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:083
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache-mod_perl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"apache-mod_perl-2.0.54_2.0.1-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-mod_perl-devel-2.0.54_2.0.1-6.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-mod_perl-2.0.2-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-mod_perl-devel-2.0.2-8.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"apache-mod_perl-", release:"MDK2006.0")
 || rpm_exists(rpm:"apache-mod_perl-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1349", value:TRUE);
}
