#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:111
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25429);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-7108");
 
 name["english"] = "MDKSA-2007:111: util-linux";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:111 (util-linux).

login in util-linux-2.12a (and later versions) skips pam_acct_mgmt
and chauth_tok when authentication is skipped, such as when a
Kerberos krlogin session has been established, which might allow
users to bypass intended access policies that would be enforced by
pam_acct_mgmt and chauth_tok.
Updated packages have been patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:111
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util-linux package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"losetup-2.12r-8.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mount-2.12r-8.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.12r-8.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"losetup-2.12r-12.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mount-2.12r-12.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.12r-12.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"util-linux-", release:"MDK2007.0")
 || rpm_exists(rpm:"util-linux-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2006-7108", value:TRUE);
}
