#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:113
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25431);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1558", "CVE-2007-2683");
 
 name["english"] = "MDKSA-2007:113: mutt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:113 (mutt).

A flaw in the way mutt processed certain APOP authentication requests
was discovered. By sending certain responses when mutt attempted to
authenticate again an APOP server, a remote attacker could possibly
obtain certain portions of the user's authentication credentials
(CVE-2007-1558).
A flaw in how mutt handled certain characters in gecos fields could
lead to a buffer overflow. A local user able to give themselves a
carefully crafted Real Name could potentially execute arbitrary code
if a victim used mutt to expand the attacker's alias (CVE-2007-2683).
Updated packages have been patched to address these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:113
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mutt-1.5.11-5.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-utf8-1.5.11-5.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.5.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-utf8-1.5.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"mutt-", release:"MDK2007.0")
 || rpm_exists(rpm:"mutt-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
