#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:128
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25563);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2006-4168");
 
 name["english"] = "MDKSA-2007:128: libexif";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:128 (libexif).

Another integer overflow was found in the way libexif parses EXIF
image tags. An individual who opened a carefully-crafted EXIF image
file could cause the application linked against libexif to crash or
possibly execute arbitrary code.
Updated packages have been patched to prevent this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:128
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libexif package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libexif12-0.6.13-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif12-devel-0.6.13-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif12-0.6.13-4.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif12-devel-0.6.13-4.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libexif-", release:"MDK2007.0")
 || rpm_exists(rpm:"libexif-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
