#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:175
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26007);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2807");
 
 name["english"] = "MDKSA-2007:175: eggdrop";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:175 (eggdrop).

A stack-based buffer overflow in mod/server.mod/servrmsg.c in Eggdrop
1.6.18, and possibly earlier, allows user-assisted, malicious remote
IRC servers to execute arbitrary code via a long private message.
Updated packages fix this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:175
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the eggdrop package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"eggdrop-1.6.17-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"eggdrop-1.6.17-3.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"eggdrop-", release:"MDK2007.0")
 || rpm_exists(rpm:"eggdrop-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-2807", value:TRUE);
}
