#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:181
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26048);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3999");
 
 name["english"] = "MDKSA-2007:181: librpcsecgss";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:181 (librpcsecgss).

A stack buffer overflow vulnerability was discovered in the RPCSEC_GSS
RPC library by Tenable Network Security that could potentially allow
for the execution of arbitrary code.
Updated packages have been patched to prevent these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:181
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the librpcsecgss package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"librpcsecgss2-0.12-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"librpcsecgss2-devel-0.12-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"librpcsecgss3-0.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"librpcsecgss3-devel-0.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"librpcsecgss-", release:"MDK2007.0")
 || rpm_exists(rpm:"librpcsecgss-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-3999", value:TRUE);
}
