#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:194
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27069);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4065", "CVE-2007-4066");
 
 name["english"] = "MDKSA-2007:194: libvorbis";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:194 (libvorbis).

More vulnerabilities in libvorbis were found that could be used to
cause an application linked to libvorbis to crash or execute arbitrary
code if used to open a carefully crafted OGG file.
Updated packages have been patched to prevent this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:194
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libvorbis package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libvorbis0-1.1.2-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis0-devel-1.1.2-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbisenc2-1.1.2-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbisfile3-1.1.2-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis0-1.1.2-1.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis0-devel-1.1.2-1.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbisenc2-1.1.2-1.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbisfile3-1.1.2-1.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libvorbis-", release:"MDK2007.0")
 || rpm_exists(rpm:"libvorbis-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
