#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:197
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27070);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4476");
 
 name["english"] = "MDKSA-2007:197: tar";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:197 (tar).

A buffer overflow in GNU tar has unspecified attack vectors and impact,
resulting in a crashing stack.
Updated packages fix this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:197
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tar package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tar-1.15.91-1.3mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.16-3.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.18-1.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"tar-", release:"MDK2007.0")
 || rpm_exists(rpm:"tar-", release:"MDK2007.1")
 || rpm_exists(rpm:"tar-", release:"MDK2008.0") )
{
 set_kb_item(name:"CVE-2007-4476", value:TRUE);
}
