#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:200
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27519);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5137", "CVE-2007-5378");
 
 name["english"] = "MDKSA-2007:200: tk";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:200 (tk).

A vulnerablity in Tk was found that could be used to overrun a buffer
when loading certain GIF images. If a user were tricked into opening
a specially crafted GIF file, it could lead to a denial of service
condition or possibly the execution of arbitrary code with the user's
privileges.
Updated packages have been patched to prevent this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:200
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tk package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libtk8.4-8.4.13-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtk8.4-devel-8.4.13-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.4.13-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtk8.4-8.4.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtk8.4-devel-8.4.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.4.14-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtk-devel-8.5a6-8.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtk8.5-8.5a6-8.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.5a6-8.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"tk-", release:"MDK2007.0")
 || rpm_exists(rpm:"tk-", release:"MDK2007.1")
 || rpm_exists(rpm:"tk-", release:"MDK2008.0") )
{
 set_kb_item(name:"CVE-2007-5137", value:TRUE);
 set_kb_item(name:"CVE-2007-5378", value:TRUE);
}
