#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:205
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27623);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4924");
 
 name["english"] = "MDKSA-2007:205: opal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:205 (opal).

A flaw in opal, the Open Phone Abstraction Library, was found in
how it handles certain Session Initiation Protocol (SIP) packets.
An attacker could use this vulnerability to crash an application
linked to opal, such as Ekiga.
Updated packages have been patched to prevent these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:205
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the opal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libopal2-2.2.3-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libopal2-devel-2.2.3-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libopal2-2.2.6-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libopal2-devel-2.2.6-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"opal-", release:"MDK2007.0")
 || rpm_exists(rpm:"opal-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-4924", value:TRUE);
}
