#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:217
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28200);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5266", "CVE-2007-5268", "CVE-2007-5269");
 
 name["english"] = "MDKSA-2007:217: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:217 (libpng).

Multiple vulnerabilities were discovered in libpng:
An off-by-one error when handling ICC profile chunks in the
png_set_iCCP() function (CVE-2007-5266; only affects Mandriva Linux
2008.0).
George Cook and Jeff Phillips reported several errors in pngrtran.c,
such as the use of logical instead of bitwise functions and incorrect
comparisons (CVE-2007-5268; only affects Mandriva Linux 2008.0).
Tavis Ormandy reported out-of-bounds read errors in several PNG chunk
handling functions (CVE-2007-5269).
Updated packages have been patched to correct these issues.
For Mandriva Linux 2008.0, libpng 1.2.22 is being provided which
corrects all three issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:217
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libpng3-1.2.12-2.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-devel-1.2.12-2.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-static-devel-1.2.12-2.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-1.2.13-2.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-devel-1.2.13-2.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-static-devel-1.2.13-2.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.22-0.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-source-1.2.22-0.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-static-devel-1.2.22-0.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng3-1.2.22-0.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libpng-", release:"MDK2007.0")
 || rpm_exists(rpm:"libpng-", release:"MDK2007.1")
 || rpm_exists(rpm:"libpng-", release:"MDK2008.0") )
{
 set_kb_item(name:"CVE-2007-5266", value:TRUE);
 set_kb_item(name:"CVE-2007-5268", value:TRUE);
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
