#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:223
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28273);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 
 name["english"] = "MDKSA-2007:223: pdftohtml";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:223 (pdftohtml).

Alin Rad Pop found several flaws in how PDF files are handled
in pdftohtml. An attacker could create a malicious PDF file that
would cause pdftohtml to crash or potentially execute arbitrary code
when opened.
The updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:223
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pdftohtml package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pdftohtml-0.36-5.3mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pdftohtml-0.39-1.2mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"pdftohtml-", release:"MDK2007.0")
 || rpm_exists(rpm:"pdftohtml-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
