#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:234
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29201);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1856");
 
 name["english"] = "MDKSA-2007:234: vixie-cron";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:234 (vixie-cron).

Raphael Marichez discovered a denial of service bug in how vixie-cron
verifies crontab file integrity. A local user with the ability
to create a hardlink to /etc/crontab could prevent vixie-cron from
executing certain system cron jobs.
The updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:234
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the vixie-cron package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"vixie-cron-4.1-9.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-9.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-9.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"vixie-cron-", release:"MDK2007.0")
 || rpm_exists(rpm:"vixie-cron-", release:"MDK2007.1")
 || rpm_exists(rpm:"vixie-cron-", release:"MDK2008.0") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
